#!/bin/sh
#-----------------------------------------------------------------------
# Installation Alephino 5.0
# (c) ExLibris (D) GmbH 2018
#-----------------------------------------------------------------------

#
# Besonderheit bei echo hinsichtlich Interpretation Steuerzeichen
#
myecho()
{
  schreib=echo
  if [ $mysys = "Linux" ]
  then
    schreib="echo -e";
  fi
}

#
# Ausgabe Kopfmeldung
#
headout()
{
  clear
  $schreib "\033[7m"
  echo "----------------------------------------------------------------------"
  echo "       Installation Alephino 5.0    (c) ExLibris(D) GmbH 2018         "
  echo "----------------------------------------------------------------------"
  $schreib "\033[0m"
  echo "       (Protocol can be found in $protfile)"
}

#
# Ausgabe Meldung auf Position 
#
poscurs()
{
  $schreib "\033["$1";"$2"H"$3"\c"
}

#
# Ausgabe Meldung in Bildschirmmitte
#
msgout()
{
  $schreib "\033[22;20H\033[7m"$1"\033[0m\033[23;1H"
}

#
# Test ob Betriebssystem unterstuetzt
#
getsys()
{
  sysok=1
  osbin=""

  case $mysys in
    "SunOS" )   osbin="sun.tar"
               ;;
    "Linux" )   osbin="linux.tar"
               ;;
    *)         poscurs 8 40 "sorry - OS not supported !"
               return
               ;;
  esac
  sysok=0
}

#
#  Einlesen Zielpfad
#
getpath()
{
  pathok=1
  
  while true
  do
  {
  poscurs 10 1 "Please enter target directory for Alephino :"
  read destpath
  if [ $destpath ]
  then
    break
  fi
  }
  done

  test -d $destpath
  if  [ $? -ne 0 ]
  then
  {
     headout
     poscurs 9 1 "Directory $destpath doesn't exist."
     poscurs 10 1 "Should it be created? (y/n):"
     read yorn
     if [ $yorn != "j" -a $yorn != "y" ]
     then
       return
     fi

     mkdir $destpath 1>>$protfile 2>&1
     if [ $? -ne 0 ]
     then
     {
       poscurs 12 1 "Error creating $destpath"
       return
     }
     fi
  }
  else
  {
    if [ -r $destpath/etc/alephino.cfg ] 
    then
    {
       poscurs 12 1 "Existing Alephino environment cannot be overwritten."
       poscurs 13 1 "Please choose another directory !"
       msgout "Installation aborted"
       exit
    }
    fi
  }
  fi
  pathok=0
}

#
#  Einlesen Quellpfad fuer Update-Installation
#
getupdatepath()
{
  srcpathok=0

  headout
  poscurs 9 1 "Update from Release 3.0 or 4.x? (y/n):"
  read yorn
  if [ $yorn != "j" -a $yorn != "y" ]
  then
    return
  fi

  srcpathok=1
  while true
  do
  {
  poscurs 10 1 "Where Alephino can be found? :"
  read srcpath
  if [ $srcpath ]
  then
    break;
  fi
  }
  done

  test -d $srcpath
  if  [ $? -ne 0 ]
  then
  {
     poscurs 12 1 "Directory $srcpath doesn't exist."
     return;
  }
  fi

  if [ -r $srcpath/etc/mabword.trl ]
  then
     srcver=3
  elif [ -r $srcpath/etc/utf2word.trl ]
  then
     srcver=4
  fi

  if [ ! $srcver ]
  then
  {
     poscurs 12 1 "Directory $srcpath doesn't contain an Alephino."
     return;
  }
  fi
  srcpathok=0
}

#
#  Pruefen und ggfs. Anlegen Verzeichnis
#
alidir()
{
  cd $destpath
  test -d $destpath/$1
  if [ $? -ne 0 ]
  then
  {
    echo "Creating directory $destpath/$1" >> $protfile
    mkdir $destpath/$1 1>>$protfile 2>&1
    chmod ug+w $destpath/$1
  }
  fi
}

#
#  Einlesen Netzwerkname
#
getnetnam()
{
  headout
  poscurs 10 1 "Please enter IP address or network name of the server in order"
  poscurs 11 1 "to configure Alephino Web-services: $defnetnam "
  poscurs 11 39 ""
  read netnam
  if [ -z "$netnam" ]
  then
    netnam=$defnetnam
  fi
}

#
#  Einlesen Portnummer fuer Web-OPAC
#
getopacport()
{
  headout
  poscurs 10 1 "Please enter port number for the Web-OPAC: $defopacport"
  poscurs 10 49 ""
  read opacport
  if [ -z "$opacport" ]
  then
    opacport=$defopacport
  fi
}

#
#  Einlesen Portnummer fuer Web-Admin
#
getadmiport()
{
  headout
  poscurs 10 1 "Please enter port number for the Web-Administration: $defadmiport"
  poscurs 10 55 ""
  read admiport
  if [ -z "$admiport" ]
  then
    admiport=$defadmiport
  fi
}

#
#  Einlesen Mailserver
#
getmailserver()
{
  while true
  do
  {
  headout
  poscurs 10 1 "Please enter IP address or network name of SMTP-server,"
  poscurs 11 1 "to be used by Alephino: "
  read mailserver
  if [ $mailserver ]
  then
    break
  fi
  }
  done
}

#
#  Einlesen Absenderadresse
#
getmailfrom()
{
  while true
  do
  {
  headout
  poscurs 10 1 "Please enter a valid email to be used as sender address"
  poscurs 11 1 "for Web-OPAC mail messages: "
  read mailfrom
  if [ $mailfrom ]
  then
    break
  fi
  }
  done
}

#
# Umsetzen Basisverzeichnis fuer Shell-Skripte
#
setaliroot()
{
  thescript="$destpath"/bin/"$1"

  if [ -f $thescript ]
  then
  {
    sed -e "s%ALIROOT%$destpath%" < $thescript > "$destpath"/tempfile
    mv -f "$destpath"/tempfile $thescript
    chmod +x $thescript
  }
  fi
}

#
# Umsetzen Quell-Basisverzeichnis fuer Upgrade-Skript
#
setsrcroot()
{
  thescript="$destpath"/bin/"$1"

  if [ -f $thescript ]
  then
  {
    sed -e "s%SRCROOT%$srcpath%" < $thescript > "$destpath"/tempfile
    mv -f "$destpath"/tempfile $thescript
    chmod +x $thescript
  }
  fi
}

#
# Zusammenfassung der Parameter
#
summary()
{
  headout
  poscurs 8 1 "Target directory: "$destpath
  poscurs 9 1 "Server name or IP address: "$netnam 
  poscurs 10 1 "SMTP-server: "$mailserver" Sender: "$mailfrom
  poscurs 11 1 "OPAC-port: "$opacport" Admin-port: "$admiport
  if [ $srcpath ]
  then
  {
    if [ $srcver -eq 3 ]
    then
      poscurs 12 1 "Update Release 3.0 from: "$srcpath
    else
      poscurs 12 1 "Update Release 4.x from: "$srcpath
    fi
  }
  fi
  poscurs 14 1 "Do you want to start with the above values now? (y/n): "
  read yorn
  if [ $yorn != "j" -a $yorn != "y" ]
  then
    exit
  fi

  echo "Target directory: "$destpath >> $protfile
  echo "Server name or IP address: "$netnam  >> $protfile
  echo "SMTP-server: "$mailserver" Sender: "$mailfrom >> $protfile
  echo "OPAC-port: "$opacport" Admin-port: "$admiport >> $protfile
  if [ $srcpath ]
  then
  {
    if [ $srcver -eq 3 ]
    then
      echo "Update Release 3.0 from: "$srcpath >> $protfile
    else
      echo "Update Release 4.x from: "$srcpath >> $protfile
    fi
  }
  fi
  headout
}

#
# Update von Version 3.0
#
update30()
{
  poscurs 13 1 "3) Copying update utilities..."
  echo "Copying update utilities to $srcpath" >> $protfile
  mv $destpath/upgrade/unload.sh $srcpath/bin 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying unload.sh"
    msgout "Installation aborted"
    exit
  }
  fi

  echo "Setting execute permission to adm_upgrade" >> $protfile
  chmod ug+x $srcpath/bin/unload.sh 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error setting permission"
    msgout "Installation aborted"
    exit
  }
  fi

  mv $destpath/upgrade/unload.cmd $srcpath/etc 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying unload.cmd"
    msgout "Installation aborted"
    exit
  }
  fi

  mv $destpath/upgrade/exec_unload.cmd $srcpath/etc 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying exec_unload.cmd"
    msgout "Installation aborted"
    exit
  }
  fi

  echo "Preparing update" >> $protfile
  mv $destpath/upgrade/upgrade.cmd $destpath/etc 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying upgrade.cmd"
    msgout "Installation aborted"
    exit
  }
  fi
  mv $destpath/upgrade/exec_upgrade.cmd $destpath/etc 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying exec_upgrade.cmd"
    msgout "Installation aborted"
    exit
  }
  fi
  mv $destpath/upgrade/statshift.txt $destpath/etc 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying statshift.txt"
    msgout "Installation aborted"
    exit
  }
  fi
  mv $destpath/upgrade/upgrade.sh $destpath/bin 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error copying upgrade.sh"
    msgout "Installation aborted"
    exit
  }
  fi
  setsrcroot upgrade.sh
  chmod ug+x $destpath/bin/upgrade.sh 1>>$protfile 2>&1
}

#
# Update von Version 4.x
#
update40()
{
  poscurs 13 1 "3) Copying databases..."
  echo "Copying databases to $destpath/pools" >> $protfile
  cp $srcpath/pools/DD???? $destpath/pools 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error while copying"
    msgout "Installation aborted"
    exit
  }
  fi
}

#
# Hauptprogramm
#

  srcpath=""
  srcver=0
  netnam=""
  mailserver=""
  mailfrom=""
  defopacport="8070"
  defadmiport="8040"

  mysys=`uname`
  defnetnam=`uname -n`
  myecho
  orgpath=`pwd`
  protfile=$HOME/alephino_50.prot
  uidlist="alephino alipac aliadm aliadz alix adm_batch zgate"
  headout

  echo "-------------- ALEPHINO 5.0 Installation ---------------" > $protfile
  date >> $protfile
  os=`uname -rs`
  echo "Operating system: $os" >> $protfile
  $schreib "\nOperating system:" "\033[7m"$os"\033[0m"

# Testen Betriebssystem
  getsys
  if [ $sysok -ne 0 ]
  then
  {
    msgout "Installation aborted"
    exit
  }
  fi
    
# Einlesen Zielpfad
  getpath
  if [ $pathok -ne 0 ]
  then
  {
    msgout "Installation aborted"
    exit
  }
  fi

# Update-Installation
  getupdatepath
  if [ $srcpathok -ne 0 ]
  then
  {
    msgout "Installation aborted"
    exit
  }
  fi

# Weitere Angaben fuer die Web-Konfiguration
  getnetnam
  getmailserver
  getmailfrom
  getopacport
  getadmiport

# Zusammenfassung und Bestaetigung vor Start
  summary

# Kopieren Umgebung
  poscurs 10 1 "1) Preparing Alephino runtime environment..."
  echo "Copying unixenv.tar to $destpath" >> $protfile
  cp unixenv.tar $destpath 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 12 1 "Error copying archive unixenv.tar to $destpath"
    msgout "Installation aborted"
    exit
  }
  fi
  cd $destpath
  echo "Unfold unixenv.tar" >> $protfile
  tar xvf unixenv.tar 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 12 1 "Error unfolding unixenv.tar"
    msgout "Installation aborted"
    exit
  }
  fi

# Komplettieren Verzeichnisbaum
  alidir temp
  alidir backup
  alidir print
  alidir version
  alidir pools
  alidir data
  alidir data/photo
  alidir data/objects
  alidir data/upload
  alidir bin

#
# Vorbereiten Skripte
#
  poscurs 11 1 "2) Preparing scripts..."
  setaliroot alephino.rc.debian
  setaliroot alephino.rc.suse
  setaliroot savepool.sh
  setaliroot rss.sh

# Kopieren Binaries
  cd $orgpath
  poscurs 12 1 "3) Copying programs for $os..."
  echo "Copying $osbin to $destpath" >> $protfile
  cp $osbin $destpath 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 14 1 "Error copying archive $osbin to $destpath"
    msgout "Installation aborted"
    exit
  }
  fi

  cd $destpath
  echo "Unfold $osbin" >> $protfile
  tar xvf $osbin 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 14 1 "Error unfolding $osbin"
    msgout "Installation aborted"
    exit
  }
  fi

# Setzen Ausfuehrungsrechte
  cd $destpath
  poscurs 13 1 "4) Set access permissions..."
  echo "Set access permissions" >> $protfile
  chmod -R ug+w *
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error setting permissions"
    msgout "Installation aborted"
    exit
  }
  fi
  cd $destpath/bin
  chmod ug+xs $uidlist 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error setting permissions"
    msgout "Installation aborted"
    exit
  }
  fi
  ln -s libxalian-c.so.110 libxalian-c.so 1>>$protfile 2>&1
  if [ $? -ne 0 ]
  then
  {
    poscurs 15 1 "Error creating symlink for Xalan"
    msgout "Installation aborted"
    exit
  }
  fi

# WWW-Konfiguration
  cd $destpath
  poscurs 14 1 "5) Creating Apache configuration..."
  echo "Creating Apache configuration" >> $protfile

  apaconf='vhost.alephino'
  touch $apaconf
  if [ $? -ne 0 ]
  then
  {
    poscurs 16 1 "Error creating Apache configuration"
    msgout "Installation aborted"
  }
  fi

echo "#" >> $apaconf
echo "# ExLibris(D) GmbH" >> $apaconf
echo "# Settings for Alephino 5.0" >> $apaconf
echo "#" >> $apaconf
echo "" >> $apaconf
echo "# Server for local operation" >> $apaconf
echo "# ServerName $netnam"  >> $apaconf
echo "" >> $apaconf
echo "# Ports for Alephino services" >> $apaconf
echo "Listen $admiport" >> $apaconf
echo "Listen $opacport" >> $apaconf
echo "" >> $apaconf
#
echo "# Allow access to Alephino directories" >> $apaconf
echo "<Directory  \"$destpath\">" >> $apaconf
echo "Order allow,deny" >> $apaconf
echo "Allow from all" >> $apaconf
echo "Options -Indexes" >> $apaconf
echo "</Directory>" >> $apaconf
echo "" >> $apaconf
#
echo "# Alephino OPAC" >> $apaconf
echo "<VirtualHost *:$opacport>" >> $apaconf
echo "AddDefaultCharset UTF-8" >> $apaconf
echo "AddType application/x-Research-Info-Systems .ris" >> $apaconf
echo "ScriptAlias /alipac \"$destpath/bin/alipac\"" >> $apaconf
echo "ErrorLog \"$destpath/temp/alipac_error.log\"" >> $apaconf
echo "TransferLog \"$destpath/temp/alipac_access.log\"" >> $apaconf
echo "Alias /download \"$destpath/temp\"" >> $apaconf
echo "Alias /pix \"$destpath/htdoc\"" >> $apaconf
echo "Alias /repository \"$destpath/data/objects\"" >> $apaconf
echo "</VirtualHost>" >> $apaconf
echo "" >> $apaconf
#
echo "# Alephino Administration" >> $apaconf
echo "<VirtualHost *:$admiport>" >> $apaconf
echo "AddDefaultCharset UTF-8" >> $apaconf
echo "Alias /german \"$destpath/htdoc/aliadm_ger\"" >> $apaconf
echo "Alias /english \"$destpath/htdoc/aliadm_eng\"" >> $apaconf
echo "Alias /portugues \"$destpath/htdoc/aliadm_por\"" >> $apaconf
echo "Alias /documents \"$destpath/data/upload\"" >> $apaconf
echo "Alias /wjhk.jupload.jar \"$destpath/bin/wjhk.jupload.jar\"" >> $apaconf
echo "ScriptAlias /aliadm \"$destpath/bin/aliadm\"" >> $apaconf
echo "ScriptAlias /aliadz \"$destpath/bin/aliadz\"" >> $apaconf
echo "ScriptAlias /alix \"$destpath/bin/alix\"" >> $apaconf
echo "ScriptAlias /upload \"$destpath/bin/upload\"" >> $apaconf
echo "ScriptAlias /cgistart \"$destpath/bin/cgistart\"" >> $apaconf
echo "ErrorLog \"$destpath/temp/aliadm_error.log\"" >> $apaconf
echo "TransferLog \"$destpath/temp/aliadm_access.log\"" >> $apaconf
echo "" >> $apaconf
echo "# Authentication" >> $apaconf
echo "#<Directory \"$destpath/bin\">" >> $apaconf
echo "#AllowOverride AuthConfig" >> $apaconf
echo "#AuthType Basic" >> $apaconf
echo "#AuthName \"Alephino Administration\"" >> $apaconf
echo "#AuthUserFile \"$destpath/passwords\"" >> $apaconf
echo "#Require user alephino" >> $apaconf
echo "#</Directory>" >> $apaconf
echo "" >> $apaconf
echo "</VirtualHost>" >> $apaconf

  cd $destpath/etc
  poscurs 15 1 "6) Creating Web-OPAC configuration..."
  echo "Creating Web-OPAC configuration" >> $protfile

  pacconf='alipac.cfg'
  aliconf='alephino.cfg'

echo "" >> $pacconf
echo "(Communication)" >> $pacconf
echo "Mail = $mailserver" >> $pacconf
echo "" >> $pacconf
echo "(Webapp)" >> $pacconf
echo "MailFrom = $mailfrom" >> $pacconf
echo "" >> $pacconf

echo "" >> $aliconf
echo "(Communication)" >> $aliconf
echo "Mail = $mailserver" >> $aliconf

echo "" >> $aliconf
echo "(Webapp)" >> $aliconf
echo "MailFrom = $mailfrom" >> $aliconf
echo "RecordInOPAC = http://$netnam:$opacport/alipac/-/full-record?IDN=%ld" >> $aliconf

echo "" >> $aliconf
echo "(Templates)" >> $aliconf
echo "ObjectAlias = http://$netnam:$opacport/repository" >> $aliconf
echo "" >> $aliconf


# Aufraeumen
  cd $destpath
  poscurs 16 1 "7) Cleaning up..."
  echo "Deleting archives" >> $protfile
  rm -f $destpath/unixenv.tar 1>>$protfile 2>&1
  rm -f $destpath/$osbin 1>>$protfile 2>&1
  cd $orgpath

# Upgrade
  if [ $srcpath ] 
  then
  {
    if [ $srcver -eq 3 ]
    then
      msgout "Start Update from Version 3.0 using $srcpath <ENTER>"
    else
      msgout "Start Update from Version 4.x using $srcpath <ENTER>"
    fi

    read anykey
    headout
    poscurs 11 1 "1) Copying license and user file..."
    echo "Copying license and user file to $destpath" >> $protfile
    cp $srcpath/etc/alephino.lic $destpath/etc 1>>$protfile 2>&1
    if [ $? -ne 0 ]
    then
    {
      poscurs 13 1 "Error copying alephino.lic"
      msgout "Installation aborted"
      exit
    }
    fi
    cp $srcpath/etc/alephino.usr $destpath/etc 1>>$protfile 2>&1
    if [ $? -ne 0 ]
    then
    {
      poscurs 13 1 "Error copying alephino.usr"
      msgout "Installation aborted"
      exit
    }
    fi

    poscurs 12 1 "2) Copying patron photographs..."
    echo "Copying patron photographs to $destpath/data/photo" >> $protfile
    cp $srcpath/data/photo/* $destpath/data/photo 1>>$protfile 2>&1
    if [ $? -ne 0 ]
    then
    {
      poscurs 14 1 "Error while copying"
      msgout "Installation aborted"
      exit
    }
    fi

    if [ $srcver -eq 3 ]
    then
      update30
    else
      update40
    fi
  }
  fi

# Schlussmeldungen
  echo "Installation successfully completed" >> $protfile
  msgout "Installation successfully completed <ENTER>"
  read anykey
  headout
  poscurs 8 1  "In order to complete your installation please:"
  poscurs 10 1  "1) Copy license file alephino.lic into"
  poscurs 11 4 "directory $destpath/etc"
  poscurs 13 1 "2) Add Web-services to httpd.conf using directive:"
  poscurs 14 4 "Include $destpath/vhost.alephino"
  poscurs 15 1 "3) If digital repository has been used:"
  poscurs 16 4 "Move directory \"objects\" to $destpath/data"
  msgout "--------------- OK -------------------"
