#!/bin/sh

LD_LIBRARY_PATH=`pwd`
export LD_LIBRARY_PATH
SRC_ROOT=SRCROOT

clear
echo Alephino Upgrade from Release 3.0
echo
echo ---------------------------------------------------------------------------
echo "  You already have unloaded the Alephino 3.0 database."
echo "  The base will now be rebuilt to be used with Alephino 5.0"
echo "  Please be aware that this procedure will take some time."
echo ---------------------------------------------------------------------------
echo
echo Press any key to continue ... 
read c
echo 
echo "  Copying loadable files from version 3.0 ..."
clear
test -f $SRC_ROOT/upgrade/tit.exp
if  [ $? -ne 0 ]
then
{
echo ---------------------------------------------------------------------------
echo "  Not any loadable file could be found."
echo "  Please perform the unload procedure on your Alephino 3.0 database."
echo ---------------------------------------------------------------------------
echo
echo Press any key to continue ... 
read c
exit
}
fi

rm -f ../upgrade/*
if [ $? -ne 0 ]
then
{
   echo "  Error while cleaning up directory ../upgrade"
   exit
}
fi

cp -f $SRC_ROOT/upgrade/* ../upgrade/
if [ $? -ne 0 ]
then
{
   echo "  Error while copying loadable files from version 3.0"
   exit
}
fi

./adm_batch < ../etc/upgrade.cmd
echo
echo ---------------------------------------------------------------------------
echo "  After finishing the upgrade procedure, please don\'t forget to save"
echo "  the Alephino database immediatly after server start using the"
echo "  Web-admin tool."
echo ---------------------------------------------------------------------------
echo
echo Press any key to continue ... 
read c
