#!/bin/sh

LD_LIBRARY_PATH=`pwd`
export LD_LIBRARY_PATH

clear
echo Alephino Upgrade from Release 3.0
echo
echo ---------------------------------------------------------------------------
echo "  Your Alephino 3.0 database will now be unloaded."
echo "  Please be aware that this procedure takes some time."
echo ---------------------------------------------------------------------------
echo
echo Press any key to continue ... 
read c
clear
echo "   Preparing directory for upgrade files ..." 
echo
test -d ../upgrade
if  [ $? -ne 0 ]
then
{
  mkdir ../upgrade
  if [ $? -ne 0 ]
  then
  {
     echo "   Error while creating directory ../upgrade"
     exit
  }
  fi
}
else
{
  rm -f ../upgrade/*
  if [ $? -ne 0 ]
  then
  {
     echo "   Error while cleaning up directory ../upgrade"
     exit
  }
  fi
}
fi

./adm_batch < ../etc/unload.cmd
echo
echo ---------------------------------------------------------------------------
echo "  The data are now ready to be loaded into version 5.0"
echo ---------------------------------------------------------------------------
echo
echo Press any key to continue ... 
read c
