<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
File : rss2html.xsl
Zweck: Anzeigen RSS-Feed "Neuerwerbungsliste" falls Browser keinen Feedreader enthaelt
-->

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino RSS</title>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<!-- Channel (Root) -->
<xsl:template match="channel">
  <h2 style="font-style:italic"><xsl:value-of select="title" /></h2>
  <h3><xsl:value-of select="description" /></h3>

  <table border="0" cellpadding="5px" >
  <tr style="font-size:1.2em; font-weight:bold">
  <td> WWW: </td>
  <td> <a href="{link}" style="color:blue; text-decoration:none"><xsl:value-of select="link" /></a></td>
  <td> | </td>
  <td> eMail: </td>
  <td> <a href="mailto:{webMaster}" style="color:blue; text-decoration:none"><xsl:value-of select="webMaster" /></a></td>
  </tr>
  
  </table>

  <hr width="60%" /> 
  <p/>
  <table border="0" width="100%">
    <xsl:apply-templates select="item" />
  </table>
</xsl:template>

<xsl:template match="title" />
<xsl:template match="description" />
<xsl:template match="link" />
<xsl:template match="webMaster" />

<!-- Item -->
<xsl:template match="item">
 <tr>
  <td style="color:blue; font-weight:bold"><xsl:value-of select="position()" />)</td>
  <td style="color:blue; font-weight:bold"><a href="{link}"><xsl:value-of select="title" /></a></td>
 </tr>
 <tr>
  <td/>
  <td colspan="2"><xsl:value-of select="substring-before(description, '&lt;br')" /></td>
 </tr>
 <tr>
  <td/>
  <td style="font-weight:bold; color:green">&#x23f5;<xsl:value-of select="substring(pubDate, 0, 12)" /></td>
 </tr>
 <tr>
  <td/>
 </tr>

 <xsl:apply-templates select="guid" />
</xsl:template>

<!-- Verwerfen -->
<xsl:template match="guid" />

</xsl:stylesheet>
