<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body style="background-color: #F0F0F0;" > 
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="/RECORD">
  <table border="0" width="100%">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="//HEADER">
<tr> 
<xsl:for-each select="COLUMN">
  <th bgcolor="yellow">
    <xsl:value-of select="." />
  </th>
</xsl:for-each>
</tr>
</xsl:template>

<xsl:template match="//BODY/*">
 <tr> 
    <xsl:apply-templates select="NAME" />
    <xsl:apply-templates select="SUB" />
    <xsl:apply-templates select="CONTENT" />
 </tr>
</xsl:template>

<xsl:template match="NAME">
  <td style="background-color:#E6E6E6; color: #000000; font-weight: bold; font-family: Tahoma; font-size: 8pt; 
             vertical-align: top; width: 30%">
    <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="SUB">
  <td style="background-color:#E6E6E6; color: blue; font-weight: bold; font-family: Tahoma; font-size: 8pt; 
             vertical-align: top; width: 5%">
    <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="redcontent/CONTENT">
  <td style="background-color:#E6E6E6; color: red; font-weight: bold; font-family: Tahoma; font-size: 8pt; vertical-align: top;">
    <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="CONTENT">
  <td style="background-color:#E6E6E6; color: #000000; font-family: Tahoma; font-size: 8pt; 
             vertical-align: top;">
    <xsl:apply-templates />
  </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
