<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ermitteln Bereichslaenge fuer Chart-Type -->
<xsl:variable name="range" select="string-length(substring-after(/PRINTOUT/HEADER/TEXT, 'TO '))" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino Printout</title>
<!--
    <link rel="stylesheet" type="text/css" href="tablefrm.css"></link>
-->
    <style type="text/css">
    .mytd {
        font-family:arial;
        font-size:10pt;
        color:darkblue;
        text-align: right;
        }
    .myth {
         color:black;
         font-family:arial;
         font-size:10pt;
         font-weight:bold;
         vertical-align:top;
         }
    .mysum {
         color:darkblue;
         font-family:arial;
         font-size:10pt;
         font-weight:bold;
         text-align: right;
         }
    </style>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="/PRINTOUT/HEADER">
  <p style="font-family: arial; font-size: 10pt">
     <xsl:apply-templates />
  </p>
  <hr width="100%" size="3" />
</xsl:template>

<xsl:template match="REPLIST">
  <table border="0">
  <tr>
  <td>
  <table border="1">
    <xsl:apply-templates />
  </table>
  </td>
  <td>
    <iframe src="" id="ichart" width="510" height="210" frameBorder="0">
    </iframe>
  </td>
  </tr>
  </table>
</xsl:template>

<xsl:template match="REPREC | REPSUM/REPREC | ENTRY">
  <tr>
    <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER | REPLIST/FOOTER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER/TEXT | REPLIST/FOOTER/TEXT">
  <th class="myth">
    <xsl:if test="starts-with(., 'CHARTM(') or starts-with(., 'CHARTB(')">
     <a><xsl:attribute name="href" />
     <xsl:attribute name="title">Google Chart</xsl:attribute>
     <xsl:attribute name="onclick">
     <xsl:if test="starts-with(., 'CHARTM(')">
       <xsl:choose>
       <xsl:when test="$range &gt; 4">
         <xsl:text>drawcommchart(</xsl:text>
       </xsl:when>
       <xsl:otherwise>
         <xsl:text>drawmonthchart(</xsl:text>
       </xsl:otherwise>
       </xsl:choose>
     </xsl:if>
     <xsl:if test="starts-with(., 'CHARTB(')">
       <xsl:text>drawcommchart(</xsl:text>
     </xsl:if>
       <xsl:value-of select="number(substring-before(substring(current(), 8), ','))" />
       <xsl:text>, '</xsl:text>
       <xsl:value-of select="substring-before(substring-after(current(), ', '), ')')" />
          <xsl:text>'); return false;</xsl:text>
     </xsl:attribute>
     <xsl:value-of select="substring-after(current(), ')')" />
     <img>
       <xsl:attribute name="src">/english/chart.png</xsl:attribute>
       <xsl:attribute name="border">0</xsl:attribute>
     </img>
     </a>
    </xsl:if>
    <xsl:if test="not(starts-with(., 'CHART'))">
     <xsl:apply-templates />
    </xsl:if>
  </th>
</xsl:template>

<xsl:template match="REPREC/TEXT">
  <td class="mytd">
   <xsl:if test=".=''">
    <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPSUM/REPREC/TEXT">
  <td class="mysum">
   <xsl:if test=".=''">
    <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

</xsl:stylesheet>
