<?xml version="1.0" encoding="UTF-8" ?>

<!--
File:    routlist.xsl
Purpose: Print formatting for routing lists in Serials GUI
-->

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
 <html>
    <xsl:apply-templates />
 </html>
</xsl:template>

<xsl:template match="rtlheader">
  <head>
    <title>
      <xsl:apply-templates />
    </title>
  </head>
</xsl:template>

<xsl:template match="rtlbody">
  <body  style="font-family: arial; margin-top:5mm; margin-left:10mm;">
    <xsl:apply-templates />
  </body>
</xsl:template>

<xsl:template match="rtmtable">
    <table border="1" cellpadding="10px" width="90%">
       <xsl:apply-templates />
    </table>
</xsl:template>

<xsl:template match="rtmheadrow">
     <tr>
       <xsl:apply-templates />
     </tr>
</xsl:template>

<xsl:template match="rtmrow">
     <tr>
       <xsl:apply-templates />
       <td width="20%">&#160;</td>
     </tr>
</xsl:template>

<xsl:template match="rtmheadcol">
     <td><b>
       <xsl:apply-templates />
     </b></td>
</xsl:template>

<xsl:template match="rtmcol">
     <td>
       <xsl:apply-templates />
     </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
