<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino Printout</title>
<!--
    <link rel="stylesheet" type="text/css" href="tablefrm.css"></link>
-->
    <style type="text/css">
    .mytd {
        font-family:arial;
        font-size:10pt;
        color:darkblue;
        text-align: right;
        }
    .myth {
         color:black;
         font-family:arial;
         font-size:10pt;
         font-weight:bold;
         vertical-align:top;
         }
    .mysum {
         color:darkblue;
         font-family:arial;
         font-size:10pt;
         font-weight:bold;
         text-align: right;
         }
    </style>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="/PRINTOUT/HEADER">
  <p style="font-family: arial; font-size: 10pt">
     <xsl:apply-templates />
  </p>
  <hr width="100%" size="3" />
</xsl:template>

<xsl:template match="REPLIST">
  <table border="1">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="REPREC | REPSUM/REPREC">
  <tr>
    <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="XTAG">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="NAME">
</xsl:template>

<xsl:template match="CONTENT">
  <td class="mytd">
   <xsl:if test=".=''">
    <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPLIST/HEADER | REPLIST/FOOTER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER/TEXT | REPLIST/FOOTER/TEXT">
  <th class="myth">
   <xsl:apply-templates />
  </th>
</xsl:template>

</xsl:stylesheet>
