<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body>
      <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="//REPLIST">
  <table border="0">
    <xsl:apply-templates />
  </table>
  <p style="page-break-after:always;" />
</xsl:template>

<xsl:template match="//REPREC">
  <table border="0">
    <xsl:apply-templates />
  </table>
  <p style="page-break-after:always;" />
</xsl:template>

<xsl:template match="//HEADER">
  <tr>
    <td colspan="2" style="background-color: lightgrey;">
       <xsl:apply-templates />
      <br />
    </td>
  </tr>
</xsl:template>

<xsl:template match="//XTAG">
 <tr> 
  <td style="color: blue; font-family: arial; font-size: 11pt; 
             vertical-align: top; width: 30%">
    <xsl:value-of select="NAME" />
  </td>
  <td>
    <xsl:value-of select="CONTENT" />
  </td>
 </tr>
</xsl:template>

<xsl:template match="//REPLIST/HEADER | //REPLIST/FOOTER">
  <tr>
    <td colspan="2" style="font-family: comic sans ms;">
      <br />
      <xsl:value-of select="TEXT" />
    </td>
  </tr>
</xsl:template>


<!-- Und das schliessende Tag -->
</xsl:stylesheet>
