<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
File:  list_tags.xsl
Zweck: Druck einer aus Einzelsaetzen im 3-spaltigen Feldformat aus Tags und Subfeldern
       zusammengesetzten Liste 
-->

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="0">
    <xsl:apply-templates />
  </table>
</xsl:template>

<!-- Seitenkopf und -fuss -->
<xsl:template match="REPLIST/HEADER">
  <td colspan="3" style="font-family: comic sans ms; font-size: 14pt">
     <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPLIST/FOOTER">
  <td colspan="3" style="font-family: comic sans ms; font-size: 14pt">
     <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPREC">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="HEADER">
  <tr>
    <td colspan="3" style="font-family: arial black;">
      <xsl:apply-templates />
    </td>
  </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/FOOTER">
  <tr>
    <td colspan="3">
      <hr width="50%" size="3" />
    </td>
  </tr>
</xsl:template>

<xsl:template match="XTAG">
 <tr> 
    <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="NAME">
  <td style="color: blue; font-family: arial; font-size: 11pt; 
             vertical-align: top; width: 5%">
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="SUB">
  <td style="color: green; font-family: arial; font-size: 11pt; 
             vertical-align: top; width: 5%;">
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="CONTENT">
  <td style="color: black; font-family: arial; font-size: 11pt; 
             vertical-align: top;">
   <xsl:apply-templates />
  </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
