<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:loc="loc:loc">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="xml" />

<!-- Notwendige individuelle Anpassungen -->
<xsl:variable name="inst_title">Exlibris Alephino-Bibliothek - Neuerwerbungen</xsl:variable>
<xsl:variable name="inst_desc">Neuerwerbungen der Alephino-Bibliothek der vergangenen 31 Tage</xsl:variable>
<xsl:variable name="inst_editor">frank.bieber@exlibrisgroup.com (Frank Bieber)</xsl:variable>
<xsl:variable name="inst_url">http://www.exlibrisgroup.com/de/category/Alephino_Ex_Libris</xsl:variable>
<xsl:variable name="opac_root">http://aspi00.exl.de</xsl:variable>

<!-- Komposition von URLs -->
<xsl:variable name="opac_url"><xsl:value-of select="$opac_root" />/alipac</xsl:variable>
<xsl:variable name="rss_url"><xsl:value-of select="$opac_root" />/pix/alipac_ger/rss.xml</xsl:variable>
<xsl:variable name="opac_ccl"><xsl:value-of select="$opac_url" />/-/full-record?IDN=</xsl:variable>


<!-- 
  Englische Abkuerzungen der Monate fuer Formatierung des Datums nach RFC822
 -->

   <loc:monthnames xml:space="preserve">
      <month>
          <code>01</code>
          <name>Jan</name>
      </month>
      <month>
          <code>02</code>
          <name>Feb</name>
      </month>
      <month>
          <code>03</code>
          <name>Mar</name>
      </month>
      <month>
          <code>04</code>
          <name>Apr</name>
      </month>
      <month>
          <code>05</code>
          <name>May</name>
      </month>
      <month>
          <code>06</code>
          <name>Jun</name>
      </month>
      <month>
          <code>07</code>
          <name>Jul</name>
      </month>
      <month>
          <code>08</code>
          <name>Aug</name>
      </month>
      <month>
          <code>09</code>
          <name>Sep</name>
      </month>
      <month>
          <code>10</code>
          <name>Oct</name>
      </month>
      <month>
          <code>11</code>
          <name>Nov</name>
      </month>
      <month>
          <code>12</code>
          <name>Dec</name>
      </month>
   </loc:monthnames>

 <xsl:variable name="locPats"
         select="document('')/*/loc:monthnames/*"/>

 <xsl:template name="resolvename">
   <xsl:param name="thecode" />

   <xsl:variable name="thevalue">
     <xsl:for-each select="$locPats">
         <xsl:if test="code = $thecode"><xsl:value-of select="name" /></xsl:if>
     </xsl:for-each>
   </xsl:variable>

   <xsl:choose>
     <xsl:when test="string-length($thevalue) &gt; 0"><xsl:value-of select="$thevalue" /></xsl:when>
     <xsl:otherwise><xsl:value-of select="$thecode" /> (No name)</xsl:otherwise>
   </xsl:choose>

 </xsl:template>

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">

<xsl:processing-instruction name="xml-stylesheet">
href="/pix/alipac_common/rss2html.xsl" type="text/xsl"
</xsl:processing-instruction> 

<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">

<channel>
<title><xsl:value-of select="$inst_title" /></title>
<link><xsl:value-of select="$opac_url" /></link>
<atom:link rel="self" type="application/rss+xml">
  <xsl:attribute name="href"> 
    <xsl:value-of select="$rss_url" />
  </xsl:attribute>
</atom:link>
<description><xsl:value-of select="$inst_desc" /></description>
<webMaster><xsl:value-of select="$inst_editor" /></webMaster>

<xsl:apply-templates />

</channel>
</rss>
</xsl:template>

<!-- Schablone fuer einzelnes Listenelement -->
<xsl:template match="ENTRY/TEXT">
  <xsl:variable name="cdate">
    <xsl:value-of select="translate(date,'.','-')" />
  </xsl:variable>
  <xsl:variable name="rfc822date">
    <xsl:value-of select="substring($cdate,1,2)" />
    <xsl:text> </xsl:text>
    <xsl:call-template name="resolvename">
      <xsl:with-param name="thecode" select="substring($cdate,4,2)" />
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="substring($cdate,7,4)" />
    <xsl:text> 00:00:00 +0100</xsl:text>
  </xsl:variable>
  <xsl:variable name="deeplink">
      <xsl:value-of select="$opac_ccl" /><xsl:value-of select="ident" />
  </xsl:variable>
  <item>
    <title><xsl:value-of select="title" /></title>
    <description><xsl:apply-templates select="description"/></description>
    <link><xsl:value-of select="$deeplink" /></link>
    <guid><xsl:value-of select="$deeplink" /></guid>
    <xsl:if test="string-length(date) &gt; 0">
      <pubDate>
        <xsl:value-of select="$rfc822date" />
      </pubDate>
    </xsl:if>
  </item>
</xsl:template>

<!-- Description mit Umbruechen -->
<xsl:template match="description">
 <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
    <xsl:apply-templates />
 <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
</xsl:template>

<!-- Zeilenumbruch im Text -->
<xsl:template match="LF">
  <br/>
</xsl:template>

</xsl:stylesheet>
