<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino Printout</title>

<style type="text/css">
.mytd {
    font-family:Verdana,Arial;
    font-size:10pt;
    background-color:white;
   }

.myth {
    font-family:Verdana,Arial;
    font-size:10pt;
    color: darkblue;
    font-weight:bold;
    }

.myrechdr {
     background-color: silver;
     font-family: comic sans ms;
     font-size: 10pt";
     font-weight: bold;
    }

.mytitle {
     font-family: Arial;
     font-size: 10pt";
     font-weight: bold;
    }
</style>

  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="REPREC/HEADER">
  <tr>
    <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPREC/HEADER">
  <br />
  <div class="myrechdr">
    <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="REPREC/TEXT">
  <div class="mytitle">
    <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="1" width="100%">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="REPLIST/HEADER | REPLIST/ENTRY">
  <tr>
    <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER/TEXT">
  <th class="myth">
   <xsl:apply-templates />
  </th>
</xsl:template>

<xsl:template match="REPLIST/ENTRY/TEXT">
  <td class="mytd">
   <xsl:if test=".=''">
     <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

</xsl:stylesheet>
