<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoList</title>
    <style type="text/css">
    .mytd {
        font-family:arial;
        font-size:10pt;
        color:darkblue;
        vertical-align:top;
        }
    .myth {
        font-family:arial;
        font-size:10pt;
        color:black;
        font-weight:bold;
        vertical-align:top;
        }
    </style>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="//REPLIST">
  <table border="0">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/REPLIST">
  <table border="2">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="HEADER">
  <tr>
  <td colspan="6">
     <xsl:apply-templates />
  </td>
  </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/FOOTER">
    <hr width="50%" size="3" />
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/REPLIST/HEADER">
 <tr>
   <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/REPLIST/ENTRY">
 <tr>
   <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/REPLIST/HEADER/TEXT">
  <th class="myth">
   <xsl:apply-templates />
  </th>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/REPLIST/ENTRY/TEXT">
  <td class="mytd">
    <xsl:if test=".=''">
      <xsl:text>&#160;</xsl:text>
    </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="//REPLIST/HEADER | //REPLIST/FOOTER">
    <p style="font-family: comic sans ms;">
      <br />
      <xsl:apply-templates select="TEXT" />
    </p>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
