<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino Printout</title>
<!--
    <link rel="stylesheet" type="text/css" href="tablefrm.css"></link>
-->
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="/PRINTOUT/REPLIST">
  <table border="2" width="100%">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="HEADER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="ENTRY">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST">
 <td>
  <table border="1" width="100%">
    <xsl:apply-templates />
  </table>
 </td>
</xsl:template>

<xsl:template match="HEADER/TEXT">
  <th class="myth">
   <xsl:apply-templates />
  </th>
</xsl:template>

<xsl:template match="ENTRY/TEXT">
  <td class="mytd">
   <xsl:if test=".=''">
    <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<!-- Zahlen in Spalten rechtsbuendig darstellen -->
<xsl:template match="money">
  <div style="text-align:right; white-space:nowrap;">
<!--   <b>&#x20ac; </b> -->
   <xsl:apply-templates />
  </div>
</xsl:template>

</xsl:stylesheet>
