<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
File:  list_full.xsl
Zweck: Druck einer aus Einzelsaetzen im 2-spaltigen Feldformat
       zusammengesetzten Liste 
-->

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" encoding="UTF-8"/>

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="0">
    <xsl:apply-templates />
  </table>
</xsl:template>

<!-- Seitenkopf und -fuss -->
<xsl:template match="REPLIST/HEADER">
  <td colspan="2" style="font-family: comic sans ms; font-size: 14pt">
     <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPLIST/FOOTER">
  <td colspan="2" style="font-family: comic sans ms; font-size: 14pt">
     <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPREC">
  <table border="0">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="HEADER">
  <tr>
    <td colspan="2" style="font-family: arial black;">
      <xsl:apply-templates />
    </td>
  </tr>
</xsl:template>

<xsl:template match="REPLIST/ENTRY/FOOTER | REPLIST/REPREC/FOOTER">
  <tr>
    <td colspan="2">
      <hr width="50%" size="3" />
    </td>
  </tr>
</xsl:template>

<xsl:template match="XTAG | httpref">
 <tr> 
    <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="NAME">
  <td style="font-family: arial; font-size: 11pt; 
             vertical-align: top; width: 30%">
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="CONTENT">
  <td style="font-family: arial; font-size: 11pt; 
             vertical-align: top;">
   <xsl:apply-templates />
  </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
