<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
File:  list_edit.xsl
Zweck: Druck einer Liste im 1-spaltigen freien Format
-->

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecords</title>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="REPLIST">
    <xsl:apply-templates />
</xsl:template>

<!-- Seitenkopf und -fuss -->
<xsl:template match="REPLIST/HEADER | REPLIST/FOOTER">
  <span style="font-family: comic sans ms; font-size: 14pt">
     <xsl:apply-templates />
  </span>
</xsl:template>

<xsl:template match="HEADER">
  <p style="width: 100%; font-family: arial;">
  <b>
     <xsl:apply-templates />
  </b>
  </p>
</xsl:template>

<xsl:template match="ENTRY/TEXT">
  <p style="color: black; font-family: arial; font-size: 11pt; 
            vertical-align: top;">
    <xsl:apply-templates />
  </p>
  <hr width="50%" size="3" />
</xsl:template>

<xsl:template match="REPREC/TEXT">
  <p style="color: black; font-family: arial; font-size: 11pt; 
            vertical-align: top;">
    <xsl:apply-templates />
  </p>
  <hr width="50%" size="3" />
</xsl:template>


<!-- Und das schliessende Tag -->
</xsl:stylesheet>
