<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
File:    lclabel.xsl
Purpose: Print formatting for spine label sheets (LoC call number / NLM call number)
-->

<!-- XSL-Stylesheet initiation -->
<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
 xmlns:my="exlibris"
 exclude-result-prefixes="xsl my">

<xsl:variable name="columns">9</xsl:variable>
<xsl:variable name="rows">4</xsl:variable>
<xsl:variable name="height">45mm</xsl:variable>
<xsl:variable name="cellstyle">height:45mm; padding-left:3mm; padding-top:3mm; vertical-align:top; font-family:Arial; font-size:14pt;</xsl:variable>
<xsl:variable name="spacer">height:0mm;</xsl:variable>
<xsl:variable name="contents"/>

<!-- Output format assignation -->
<xsl:output method="html" />

<!-- Document-root template -->
<xsl:template match="/">
  <html>
    <body style="margin-top:10mm; margin-left:10mm; margin-right:10mm;">
      <xsl:apply-templates />
    </body>
  </html>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="1" width="100%" cellspacing="0" cellpadding="0" style="table-layout:fixed">
    <xsl:call-template name="labelsheet" />
  </table>
</xsl:template>

<!-- Handle label sheet with defined labels per row -->
<xsl:template name="labelsheet">
  <xsl:for-each select="//ENTRY/TEXT/lccall">
     <xsl:if test="(position()-1)&gt;0">
<!--
        <xsl:if test="(position()-1) mod ($columns * $rows) = 0">
           <tr><td colspan="{$columns}" style="page-break-after:always;" /></tr>
        </xsl:if>
-->
        <xsl:if test="(position()-1) mod $columns = 0">
<!--
           <tr><td colspan="{$columns}" style="{$spacer}"/></tr>
-->
           <tr><td colspan="{$columns}" /></tr>
        </xsl:if>
    </xsl:if>
    <xsl:call-template name="labelcell" />
  </xsl:for-each>

<!-- Fill up row up to number columns -->
  <xsl:variable name="numlabels" select="count(//ENTRY/TEXT/lccall)" />

  <xsl:if test="$numlabels&lt;$columns">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 1)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 2)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 3)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 4)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 5)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 6)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 7)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 8)">
    <td height="{$height}" width="{100 div $columns}%">&#160;</td>
  </xsl:if>

</xsl:template>

<xsl:template name="labelcell">
  <td width="{100 div $columns}%" style="{$cellstyle}">

    <xsl:choose>

    <xsl:when test="string(number(substring(.,3,1))) = 'NaN'">
      <xsl:value-of select="substring(.,1,3)" />
      <br/>
      <xsl:call-template name="spinelabel">
        <xsl:with-param name="labeltext" select="substring(.,4)" />
      </xsl:call-template>
    </xsl:when>

    <xsl:when test="string(number(substring(.,2,1))) = 'NaN'">
      <xsl:value-of select="substring(.,1,2)" />
      <br/>
      <xsl:call-template name="spinelabel">
        <xsl:with-param name="labeltext" select="substring(.,3)" />
      </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
      <xsl:value-of select="substring(.,1,1)" />
      <br/>
      <xsl:call-template name="spinelabel">
        <xsl:with-param name="labeltext" select="substring(.,2)" />
      </xsl:call-template>
    </xsl:otherwise>

    </xsl:choose>
  </td>
  <xsl:text>&#10;</xsl:text>
</xsl:template>

<!-- Strip leading space if present -->
  <xsl:template name="spinelabel">
   <xsl:param name="labeltext" />

   <xsl:choose>
    <xsl:when test="starts-with($labeltext,' ')">
     <xsl:call-template name="searchreplace">
       <xsl:with-param name="pText" select="substring($labeltext,2)" />
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="searchreplace">
       <xsl:with-param name="pText" select="$labeltext" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:template>

<!-- Search and replace spaces by line break -->
    <my:params xml:space="preserve">
        <pattern>
            <old>. </old>
            <new>.</new>
        </pattern>
        <pattern>
            <old>.</old>
            <new><br/>.</new>
        </pattern>
        <pattern>
            <old> </old>
            <new><br/></new>
        </pattern>
    </my:params>

    <xsl:variable name="vPats" select="document('')/*/my:params/pattern" />

    <xsl:template name="searchreplace">
        <xsl:param name="pText" />
        <xsl:param name="Foo" select="$vPats" />

        <xsl:if test="string-length($pText) >0">
            <xsl:variable name="vPat" select=
            "$vPats[starts-with($pText, old)][1]"/>

            <xsl:choose>
                <xsl:when test="not($vPat)">
                    <xsl:copy-of select="substring($pText,1,1)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:copy-of select="$vPat/new/node()"/>
                </xsl:otherwise>
            </xsl:choose>

            <!-- Rekursion -->
            <xsl:call-template name="searchreplace">
                <xsl:with-param name="pText" select=
                "substring($pText, 1 + not($vPat) + string-length($vPat/old/node()))"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

<!-- Finish -->
</xsl:stylesheet>
