<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
File:    label_form.xsl
Purpose: Print formatting for item label sheets 
         Special adjustment for Avery Zweckform type 4737
-->

<!-- XSL-Stylesheet initiation -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:variable name="maxtitle">40</xsl:variable>
<xsl:variable name="columns">3</xsl:variable>

<!-- Output format assignation -->
<xsl:output method="html" />

<!-- Line break handling -->
<xsl:template match="LF">
   <br />
</xsl:template>

<!-- Document-root template -->
<xsl:template match="/">
  <html>
    <body style="margin-top:7mm; margin-left:2mm;">
      <xsl:apply-templates />
    </body>
  </html>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="1" width="100%" cellspacing="0" cellpadding="4">
    <colgroup span="{$columns}" />
    <xsl:call-template name="labelsheet" />
  </table>
</xsl:template>

<!-- Handle label sheet with defined labels per row -->
<xsl:template name="labelsheet">
  <xsl:for-each select="//ENTRY/TEXT">
    <xsl:if test="(position()-1) mod $columns = 0">
      <tr />
    </xsl:if>
    <xsl:call-template name="labelcell" />
  </xsl:for-each>

<!-- Fill up row up to 5 columns -->
  <xsl:variable name="numlabels" select="count(//ENTRY)" />
  <xsl:if test="$numlabels&lt;$columns">
    <td width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 1)">
    <td width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 2)">
    <td width="{100 div $columns}%">&#160;</td>
  </xsl:if>
  <xsl:if test="$numlabels&lt;($columns - 3)">
    <td width="{100 div $columns}%">&#160;</td>
  </xsl:if>
</xsl:template>

<xsl:template name="labelcell">
  <td width="{100 div $columns}%">
    <xsl:call-template name="cellhead" />
    <xsl:call-template name="cellmid"  />
    <xsl:call-template name="cellfoot" />
  </td>
</xsl:template>

<!-- Collection & Call number -->
<xsl:template name="cellhead">
  <table width="100%" border="0" align="center">
    <tr>
      <td style="font-family:Arial; font-size:8pt;">
        <xsl:value-of select="collection" />
      </td>
      <td style="font-family:Arial; font-size:8pt; text-align:right;">
        <xsl:value-of select="callno" />
      </td>
    </tr>
  </table>
</xsl:template>

<!-- Barcode -->
<xsl:template name="cellmid">
   <p style="font-family:'CarolinaBar-B39-2.5-22x158x720'; 
             font-size:12pt; text-align:center;">
     <xsl:value-of select="barcode" />
  </p>
</xsl:template>

<!-- Title (cutted to 30 characters) -->
<xsl:template name="cellfoot">
  <span style="font-family:Arial; font-size:8pt; font-weight:bold;">
    <xsl:value-of select="substring(title, 0, $maxtitle)" />
     <xsl:if test="string-length(title) &gt; $maxtitle">
       <xsl:text> ...</xsl:text>
     </xsl:if>
  </span>
</xsl:template>

<!-- Currently suppressed elements -->
<xsl:template match="description">
</xsl:template>

<xsl:template match="volume">
</xsl:template>

<xsl:template match="part">
</xsl:template>


<!-- Finish -->
</xsl:stylesheet>
