<?xml version="1.0" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" />

<xsl:template match="/">
  <head>
    <link rel="stylesheet" type="text/css" href="/english/webserv.css" />
    <title>AlephinoRecord</title>
    <script type="text/javascript">
     <xsl:text>
      &lt;!--

       var orgtag;

       function pushEdit(tag)
       {
         var edittext = tag.value;
         var size = tag.size;
         var name = tag.name;
         var input = tag.parentNode;
         orgtag = input.removeChild(input.firstChild);
         var textarea = document.createElement('textarea');
         var mytext = document.createTextNode(edittext);
         var nameatt = document.createAttribute("name");
         var colatt = document.createAttribute("cols");
         var rowatt = document.createAttribute("rows");
         var spellatt  = document.createAttribute("spellcheck");
         nameatt.value = name;
         colatt.value = size;
         rowatt.value = edittext.length / size;
         if (rowatt.value &lt; 1.0)
           rowatt.value = 1;
         spellatt.value = "false";
         textarea.style.color = "blue";
         textarea.style.backgroundColor = "#f4db95";
         textarea.style.fontFamily = "Verdana";
         textarea.style.fontSize = "80%";
         textarea.setAttributeNode(colatt);
         textarea.setAttributeNode(rowatt);
         textarea.setAttributeNode(nameatt);
         textarea.setAttributeNode(spellatt);
         textarea.appendChild(mytext);
         input.appendChild(textarea);
         textarea.focus();
         textarea.value += ' ';
         var agent = navigator.userAgent;
         if (agent.indexOf("Firefox") > 0 || agent.indexOf("Chrome") > 0)
           textarea.addEventListener('blur', leaveEdit);
       }

       function leaveEdit()
       {
         var edittext = this.value;
         var input = this.parentNode;
         input.removeChild(input.firstChild);
         orgtag.setAttribute("value", edittext);
         input.appendChild(orgtag);
       }

      //--&gt;
     </xsl:text>
    </script>
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</xsl:template>

<xsl:template match="document">
  <input type="hidden" name="base" value="{@base}" />
  <input type="hidden" name="idn" value="{@idn}" />
  <h1>
    Process record:
    <xsl:value-of select="@base"/>
    / IDN=<xsl:value-of select="@idn"/>
  </h1>
    <hr/>
    <table border="0">
    <thead>
      <tr>
        <th class="td6">Tag</th><th class="td6">Indicators</th><th class="td6">[$Subfield] Data</th><th class="td6">Actions</th>
      </tr>
    </thead>
    <tbody>
      <xsl:apply-templates select="leader" />
      <xsl:apply-templates select="newmain | newsub | error | warning | controlfield | datafield" />
    </tbody>
    </table>
    <hr/>
  <xsl:if test="@idn &gt; 0">
    <input type="submit" name="SEND" value="Save" />
    <input type="submit" name="DELETE" value="Delete record" />
  </xsl:if>
  <input type="submit" name="ASNEW" value="Save as new record" />
  <xsl:text>&#160;</xsl:text>
  <a href="/english/BatchRef.htm#xedit">
  <img src="/english/book.gif" border="0" alt="Help" title="Help" /></a>
</xsl:template>

<xsl:template match="leader">
<xsl:variable name="thevalue"><xsl:value-of select="." /></xsl:variable>
  <tr>
    <td colspan="2">LDR</td>
    <td><input size="104" name="LDR" type="text" value="{$thevalue}" /></td>
    <td/>
  </tr>
</xsl:template>

<xsl:template match="controlfield">
<xsl:variable name="thevalue"><xsl:value-of select="." /></xsl:variable>
  <tr>
    <td valign="top"><xsl:value-of select="@tag" /></td>
    <td valign="top">
      <input size="1" maxlength="1" name="i1" type="text" style="width:15px" value="{@ind1}" />
      <input size="1" maxlength="1" name="i2" type="text" style="width:15px" value="{@ind2}" />
    </td>
    <td valign="top"><input size="104" name="TAG_{@tag}.{position()}" type="text" value="{$thevalue}" onclick="pushEdit(this)" /></td>
    <td>
      <input type="submit" class="insbutton" name="INSTAG" value="&lt;&lt;" title="Insert tag" />
      <input type="submit" class="delbutton" name="DELTAG" value="x" title="Delete tag" />
    </td>
  </tr>
</xsl:template>

<xsl:template match="datafield">
<xsl:variable name="thevalue"><xsl:value-of select="." /></xsl:variable>
  <tr>
    <td valign="top"><xsl:value-of select="@tag" /></td>
    <td valign="top">
      <input size="1" maxlength="1" name="i1" type="text" style="width:15px" value="{@ind1}" />
      <input size="1" maxlength="1" name="i2" type="text" style="width:15px" value="{@ind2}" />
    </td>
    <xsl:if test="count(subfield)&gt;0">
      <input type="hidden" name="MAIN" value="{@tag}.{position()}" />
      <td valign="top"><xsl:apply-templates /></td>
    <td valign="top">
      <input type="submit" class="insbutton" name="INSTAG" value="&lt;&lt;" title="Insert tag" />
      <input type="submit" class="delbutton" name="DELTAG" value="x" title="Delete tag" />
    </td>
    </xsl:if>
    <xsl:if test="count(subfield)=0">
      <td valign="top"><input size="104" name="TAG_{@tag}.{position()}" type="text" value="{$thevalue}" onclick="pushEdit(this)" /></td>
      <td>
        <input type="submit" class="insbutton" name="INSTAG" value="&lt;&lt;" title="Insert tag" />
        <input type="submit" class="delbutton" name="DELTAG" value="x" title="Delete tag" />
      </td>
    </xsl:if>
  </tr>
</xsl:template>

<xsl:template match="subfield">
<xsl:variable name="thevalue"><xsl:value-of select="." /></xsl:variable>
 <table border="0">
  <tr>
    <td>$<xsl:value-of select="@code" /></td>
    <td><input size="100" name="SUB_{../@tag}${@code}.{position()}" type="text" value="{$thevalue}" onclick="pushEdit(this)" /></td>
    <td valign="bottom">
      <input type="submit" class="insbutton" name="INSSUB" value="&lt;"  title="Insert subfield" />
      <input type="submit" class="delbutton" name="DELSUB" value="x" title="Delete subfield" />
    </td>
  </tr>
 </table>
</xsl:template>

<xsl:template match="error">
  <tr>
    <td style="background-color:red; font-size:120%;" colspan="2">Error</td>
    <td style="background-color:red;"><xsl:value-of select="." /></td>
    <td/>
  </tr>
</xsl:template>

<xsl:template match="warning">
  <tr>
    <td style="background-color:lightblue; font-size:120%;" colspan="2">Warning</td>
    <td style="background-color:lightblue;"><xsl:value-of select="." /></td>
    <td/>
  </tr>
</xsl:template>

<xsl:template match="newmain">
  <tr>
    <td valign="top"><input type="text" name="NEWMAIN" size="3" maxlength="3" style="background-color: lightgreen; width:35px" value="" /></td>
    <td valign="top">
      <input size="1" maxlength="1" name="i1" type="text" style="width:15px" value="" />
      <input size="1" maxlength="1" name="i2" type="text" style="width:15px" value="" />
    </td>
    <td valign="top"> 
     <table border="0">
      <tr>
       <td>$<input size="1" maxlength="1" name="NEWSUB" type="text" style="background-color: lightgreen; width:15px" value="" /></td>
       <td><input size="99" name="NEWVAL" type="text" value="" /></td>
      </tr>
     </table>
    </td>
  </tr>
</xsl:template>

<xsl:template match="newsub">
     <table border="0">
      <tr>
       <td>$<input size="1" maxlength="1" name="NEWSUB" type="text" style="background-color: lightgreen; width:15px" value="" /></td>
       <td><input size="99" name="NEWVAL" type="text" value="" /></td>
      </tr>
     </table>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>

