<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
File : common.xsl
Zweck: Allgemein genutzte Schablonen
-->

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Zeilenumbruch im Text -->
<xsl:template match="LF">
   <br />
</xsl:template>

<!-- Barcode -->
<xsl:template match="barcode">
   <span style="font-family:'CarolinaBar-B39-2.5-22x158x720'; 
    text-align:right;">
      <xsl:apply-templates />
   </span>
</xsl:template>

<!-- Fettdruck -->
<xsl:template match="//boldprint">
    <b>
      <xsl:apply-templates />
    </b>
</xsl:template>

<!-- zentrierte Ausgabe -->
<xsl:template match="//centerprint">
  <p style="text-align:center;">
    <xsl:apply-templates />
  </p>
</xsl:template>

<!-- Seitenkopf und -fuss -->
<xsl:template match="/PRINTOUT/HEADER">
  <p style="font-family:arial; font-size:14pt">
     <xsl:apply-templates />
  </p>
  <hr width="100%" size="3" />
</xsl:template>

<xsl:template match="/PRINTOUT/FOOTER">
  <p style="font-family:arial; font-size:14pt">
     <xsl:apply-templates />
  </p>
</xsl:template>

<!-- Bibliotheks-Adresse -->
<xsl:template match="//bibaddress">
    <p  style="font-family:arial; font-size:12pt; text-align:right">
      <xsl:apply-templates />
    </p>
</xsl:template>

<!-- Zahlen in Spalten rechtsbuendig darstellen -->
<xsl:template match="//number">
  <div style="text-align:right;">
   <xsl:apply-templates />
  </div>
</xsl:template>

<!-- Ueberschrift: Text fett links - Datum rechts -->
<xsl:template match="//subject">
    <table border="0" width="100%">
      <tr>
        <xsl:apply-templates />
      </tr>
    </table>
</xsl:template>

<xsl:template match="//subj_txt">
    <td>
      <b>
        <xsl:apply-templates />
      </b>
    </td>
</xsl:template>

<xsl:template match="//subj_date">
    <td style="text-align:right">
      <xsl:apply-templates />
    </td>
</xsl:template>

<!-- Eingebettetes Bild -->
<xsl:template match="//httpimage/CONTENT">
 <td style="color: #000000; font-family: Tahoma; font-size: 10pt; 
             vertical-align: top;">
   <img height="150" src="{.}" />
      <xsl:value-of select="." />
 </td>
</xsl:template>

<!-- Eingebettete URL -->
<xsl:template match="//httpref/CONTENT">
 <td style="color: #000000; font-family: Tahoma; font-size: 10pt; 
             vertical-align: top;">
   <a href="{.}"><xsl:value-of select="." /></a>
 </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
