<?xml version="1.0" encoding="UTF-8" ?> 
<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body style="font-family: arial; color: black ;">
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="number">
  <div style="text-align: right;">
   <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="REPLIST">
  <p />
  <table border="1">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="ENTRY">
 <tr>
   <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="ENTRY/TEXT">
  <td style="color: black;
             font-family: arial; font-size: 11pt;
             vertical-align: top;">
   <xsl:if test=".=''">
     <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="HEADER/TEXT | FOOTER/TEXT">
  <td style="color: black;
             font-family: arial; font-size: 11pt;
             vertical-align: top;">
     <b>
       <xsl:apply-templates />
     </b>
  </td>
</xsl:template>

<!-- Bilanz im Feldformat -->

<xsl:template match="/PRINTOUT/BALANCE">
  <hr />
  <table border="1" width="90%">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="//XTAG">
    <tr>
      <xsl:apply-templates />
    </tr>
</xsl:template>

<xsl:template match="NAME" >
    <td style="color: blue;
     font-family: arial; font-size: 12pt; text-align=left;">
      <xsl:apply-templates />
    </td>
</xsl:template>

<xsl:template match="CONTENT" >
    <td style="color: black;
     font-family: arial; font-size: 12pt; text-align=right;">
      <xsl:apply-templates />
    </td>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
