<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />
<xsl:include href="bor_letterhd.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body style="font-family: arial;">
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="//header">
    <p  width="50%" style="text-align: center;">
      <b>
      <xsl:apply-templates />
      </b>
    </p>
</xsl:template>

<xsl:template match="//intro">
    <br/><xsl:value-of select="." />
</xsl:template>

<xsl:template match="//linktext">
</xsl:template>

<xsl:template match="//url">
  &#160; <a href="{.}"><xsl:value-of select="//linktext" /></a><br/>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
