<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />
<xsl:include href="bor_letterhd.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body style="font-family: arial;">
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>


<xsl:template match="//REPLIST">
  <table border="1">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="//REPLIST/HEADER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="//REPLIST/HEADER/TEXT">
  <td style="color:black;
             font-family:arial; font-size:11pt;
             vertical-align:top;">
    <b>
    <xsl:if test=".=''">
      <xsl:text>&#160;</xsl:text>
    </xsl:if>
   <xsl:apply-templates />
   </b>
  </td>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY">
 <tr>
   <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/TEXT">
  <td style="color:black;
             font-family:arial; font-size:11pt;
             vertical-align:top;">
    <xsl:if test=".=''">
      <xsl:text>&#160;</xsl:text>
    </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="//HEADER | //FOOTER">
    <p align="center" style="font-weight:bold">
      <xsl:apply-templates select="TEXT" />
      <hr width="50%" />
    </p>
</xsl:template>

<xsl:template match="//euro"> 
  <xsl:apply-templates /> &#x20ac;
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
