<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />
<xsl:include href="bor_letterhd.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body>
  <div style="font-family:arial; font-size:12pt;">
    <xsl:apply-templates />
  </div>
  </body>
</html>
</xsl:template>

<xsl:template match="//REPLIST">
  <table border="1">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="//REPLIST/HEADER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="//REPLIST/HEADER/TEXT">
  <td style="color:black;
             font-family:arial; font-size:11pt;
             vertical-align:top;">
    <b>
    <xsl:if test=".=''">
      <xsl:text>&#160;</xsl:text>
    </xsl:if>
   <xsl:apply-templates />
   </b>
  </td>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY">
 <tr>
   <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="//REPLIST/ENTRY/TEXT">
  <td style="color:black;
             font-family:arial; font-size:11pt;
             vertical-align:top;">
    <xsl:if test=".=''">
      <xsl:text>&#160;</xsl:text>
    </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

<xsl:template match="REPREC">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="//credit | //debit | //wtxt">
    <p  style="font-family:arial font-size:12pt;">
      <xsl:apply-templates />
    </p>
</xsl:template>

<!--
<xsl:template match="//debit">
    <p  width="50%" align="center" style="background-color: red; 
        font-family: comic sans ms; color: black ;">
      <xsl:apply-templates />
    </p>
</xsl:template>
-->
<!--
<xsl:template match="//credit | //wtxt">
    <p  width="50%" align="center" style="background-color: green; 
        font-family: comic sans ms; color: black ;">
      <xsl:apply-templates />
    </p>
</xsl:template>
-->

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
