<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />
<xsl:include href="bor_letterhd.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>AlephinoRecord</title>
  </head>
  <body style="font-family: arial;">
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="//HEADER | //FOOTER">
    <p align="center" style="font-weight:bold">
      <xsl:apply-templates select="TEXT" />
      <hr width="50%" />
    </p>
</xsl:template>

<xsl:template match="REPLIST/ENTRY/TEXT">
  <xsl:apply-templates />
  <hr width="50%" />
</xsl:template>

<xsl:template match="//recno">
    <span style="font-weight: bold;">
      <xsl:apply-templates />
    </span>
</xsl:template>

<xsl:template match="//title">
    <span style="color: blue;">
      <xsl:apply-templates />
    </span>
</xsl:template>

<!-- Und das schliessende Tag -->
</xsl:stylesheet>
