<?xml version="1.0" encoding="UTF-8" ?>

<!-- Das oeffnende Tag eines XSL-Stylesheets -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Ausgabe-Methode festlegen -->
<xsl:output method="html" />

<!-- Ausgelagerte Templates anschliessen -->
<xsl:include href="common.xsl" />

<!-- Schablone fuer die "Wurzel" des Dokuments -->
<xsl:template match="/">
<html>
  <head>
    <title>Alephino Printout</title>
<!--
    <link rel="stylesheet" type="text/css" href="tablefrm.css"></link>
-->
  </head>
  <body>
    <xsl:apply-templates />
  </body>
</html>
</xsl:template>

<xsl:template match="REPLIST">
  <table border="1" width="100%">
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="REPREC | ENTRY">
  <tr>
    <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER | REPLIST/FOOTER">
  <tr>
   <xsl:apply-templates />
  </tr>
</xsl:template>

<xsl:template match="REPLIST/HEADER/TEXT | FOOTER/TEXT">
  <th class="myth">
   <xsl:apply-templates />
  </th>
</xsl:template>

<xsl:template match="number">
  <div style="text-align: right;">
   <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="TEXT">
  <td class="mytd">
   <xsl:if test=".=''">
    <xsl:text>&#160;</xsl:text>
   </xsl:if>
   <xsl:apply-templates />
  </td>
</xsl:template>

</xsl:stylesheet>
