#!/bin/sh
#
# Author: Frank Bieber <fb@exl.de>
#
# Automatisierung der Alephino-Datensicherung mit cron-Job
#

# Alephino Installationsverzeichnis
alipath=ALIROOT

LD_LIBRARY_PATH="$alipath"/bin
export LD_LIBRARY_PATH

ALI_DESC="Alephino 5.0 Server"
protfile="$alipath"/backup/sichprot.txt

# Individuelles Logfile zur Benachrichtigung
#
#protfile="$alipath"/backup/sichprot.txt`date +%d.%m_%H:%M`

echo ======= STOP === `date '+%d.%m.%y / %H:%M:%S'` ============== >> $protfile
cd "$alipath"/bin
#./consort.rc stop >> $protfile
./alephino.rc stop >> $protfile

echo Sicherung und Freigeben Datenpool >> $protfile
cd "$alipath"/bin
./adm_batch < ../etc/savepool.cmd 1>>$protfile 2>&1

echo ====== START === `date '+%d.%m.%y / %H:%M:%S'` ============== >> $protfile
cd "$alipath"/bin
./alephino.rc start >> $protfile
#./consort.rc start >> $protfile

# Benachrichtigung im Fehlerfall
#
# if [ `grep -c CANCELLED $protfile` -gt 0 ]; then
# {
#   mail -s 'Alephino nightly backup' sysadmin@yourlibrary.com < $protfile
# }
