#!/bin/bash

ALI_ROOT=ALIROOT
export LD_LIBRARY_PATH="$ALI_ROOT"/bin

#
# Creation of RSS for new acquisitions list depending on database and language
# a) Add ApplDict = ../etc/printrss.ext to alephino.cfg
# b) Uncomment RSS link in htdoc/alipac_[lng]/menu.htt
# c) Make language- and database-dependent copies derived from etc/xslt/list_rss.xsl
# d) RSS feed creation can be based on title (TIT) or item (MEX) records
# e) Refresh RSS feeds on a regular basis (crontab)
#
makefeed()
{
  rsscmd=../temp/rss.cmd
  rssout=../htdoc/alipac_$1/rss$2.out
  rssxml=../htdoc/alipac_$1/rss$2.xml
  fromdate=`date --date="3 months ago" +%Y%m%d`
  echo LOGIN USER=SYS PASS=SYS > $rsscmd
  echo -n XLIST POOL=$2 FILE=MEX LANGUAGE=$1 OUTPUT=$rssout FORMAT=RSS SELECT=\"EDT >> $rsscmd
  echo -n '>' >> $rsscmd
  echo -n $fromdate >> $rsscmd
  echo \" >> $rsscmd
  echo END >> $rsscmd

  if [ -r "$ALI_ROOT"/etc/xslt/$1/list_rss.xsl ]
  then
    unlink "$ALI_ROOT"/etc/xslt/$1/list_rss.xsl
  fi

  pool=`echo $2 | tr '[:upper:]' '[:lower:]'`
  if [ -r "$ALI_ROOT"/etc/xslt/$1/list_rss_$pool.xsl ]
  then
  {
    echo Mounting stylesheet for database $2
    ln -s "$ALI_ROOT"/etc/xslt/$1/list_rss_$pool.xsl "$ALI_ROOT"/etc/xslt/$1/list_rss.xsl
    echo Creating RSS for database $2
  }
  fi

  ./adm_batch < $rsscmd
  sed '1d' $rssout > $rssxml
}

./alephino.rc stop
makefeed eng M
./alephino.rc start
